package control;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.exceptions.InvalidDateException;
import sun.rmi.server.Dispatcher;
import timeline.ConcreteTimeline;
import timeline.Event;
import timeline.Timeline;

/**
 * Servlet implementation class EventAdder
 */
@WebServlet("/addition")
public class EventAdder extends HttpServlet {
	private static final long serialVersionUID = 1L;

	public EventAdder() {
		super();
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		Event event = getEventByRequest(request);
		checkApp();
		addEventToTimeline(request, event);
		redirect(request, response);
	}

	private void redirect(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.sendRedirect("/XTream/timeline.jsp");
	}

	private void addEventToTimeline(HttpServletRequest request, Event event) {
		try {
			((Timeline) super.getServletContext().getAttribute("timeline"))
					.addEvent(event);
		} catch (InvalidDateException e) {
		}
	}

	private void checkApp() {
		if (super.getServletContext().getAttribute("timeline") == null) {
			super.getServletContext().setAttribute("timeline",
					new ConcreteTimeline());
		}
	}

	private Event getEventByRequest(HttpServletRequest request) {
		Event event = new Event(request.getParameter("eventName"),
				new GregorianCalendar());
		return event;
	}

}
